using System;
using Xunit;
using Egil.RazorComponents.Testing;
using Egil.RazorComponents.Testing.Diffing;
using Egil.RazorComponents.Testing.Asserting;
using Egil.RazorComponents.Testing.Mocking.JSInterop;
using Egil.RazorComponents.Testing.EventDispatchExtensions;
using MLBlazorRCL.Komponentendateien;
using Microsoft.Extensions.DependencyInjection;
using ITVisions.Blazor;
using Microsoft.JSInterop;
using Microsoft.AspNetCore.Components;
using System.Diagnostics;
using System.Collections.Generic;

namespace BlazorTests
{

 public class Counter_Test : ComponentTestFixture
 {
  [Fact]
  public void OneClickTest()
  {
   var cut = RenderComponent<MLBlazorRCL.Komponenteneinbettung.Counter>();

   for (int i = 1; i <= 10; i++)
   {
    cut.Find("button").Click();
    cut.GetChangesSinceFirstRender().ShouldHaveSingleTextChange("Current count: " + i);
   }
  }

  List<int> ValueList = new List<int>();
  [Fact]
  public void ParameterTest()
  {

   const int StartWert = 100;
   var cut = RenderComponent<MLBlazorRCL.Komponenteneinbettung.Counter>(
    (nameof(MLBlazorRCL.Komponenteneinbettung.Counter.StartValue), StartWert),
       EventCallback(nameof(MLBlazorRCL.Komponenteneinbettung.Counter.ValueHasChanged), (int x) => ValueHasChanged(x))
    );

   cut.Find("button").Click();
   cut.GetChangesSinceFirstRender().ShouldHaveSingleTextChange("Current count: " + (StartWert + 1));
   cut.Find("button").Click();
   cut.GetChangesSinceFirstRender().ShouldHaveSingleTextChange("Current count: " + (StartWert + 2));

   Assert.Equal(101, ValueList[0]);
   Assert.Equal(102, ValueList[1]);
  }

  void ValueHasChanged(int x)
  {
   // geht hier nicht:    Assert.Equal(101, x);
   ValueList.Add(x);
  }
 }
}